function pi_models = build_transformers(idx_1,idx_2,S_max,V_n1,V_n2,R_sc,X_sc,Y_b)
% pi_models = build_transformers(idx_1,idx_2,S_max,V_1,V_2,R_sc,X_sc,Y_b)
% 
% INPUT
%   idx_1       Index of bus where primary side is connected.
%   idx_2       Index of bus where secondary side is connected.
%   S_max       Rated power.
%   V_n1        Primary-side nominal voltage.
%   V_n2        Sedondary-side nominal voltage.
%   R_sc        Short-circuit resistance in p.u. w.r.t. S_max and V_2.
%   X_sc        Short-circuit reactance in p.u. w.r.t. S_max and V_2.
%   Y_b         Base admittance
%
% OUPUT
%   pi_models   Per-unit pi-section equivalent circuits.

n_trafos = length(idx_1);

pi_models = cell(n_trafos,1);

for k=1:n_trafos    
    pi_k = struct();
    
    % **********
    
    % !!! write your own code here !!!
    
    t = V_n2(k)/V_n1(k);
    Y_sc = 1/(R_sc(k)+1i*X_sc(k)) * (S_max(k)/V_n2(k)^2) / Y_b;
    
    pi_k.i = idx_1(k);
    pi_k.j = idx_2(k);
    pi_k.Y_ij = t*Y_sc;
    pi_k.Y_i_ij = t*(t-1)*Y_sc;
    pi_k.Y_j_ij = (1-t)*Y_sc;
    
    % **********
    
    pi_models{k} = pi_k;
end

pi_models = [pi_models{:}];

end